/*
 * Decompiled with CFR 0.152.
 */
package bq_msi.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;

public class GetStructureNameCommand
extends CommandBase {
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] params) throws CommandException {
        if (sender.func_174793_f() == null || !(sender.func_174793_f() instanceof EntityPlayerMP) || sender.func_130014_f_().field_72995_K) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)sender.func_174793_f();
        if (params.length == 3 && this.isStringInt(params[0]) && this.isStringInt(params[1]) && this.isStringInt(params[2])) {
            int dim = Integer.parseInt(params[0]);
            int x = Integer.parseInt(params[1]);
            int z = Integer.parseInt(params[2]);
            String message = this.DataRead(this.convertPosToRegion(x, z), dim, x, z);
            TextComponentString text = new TextComponentString(message);
            text.func_150256_b().func_150238_a(TextFormatting.BLUE);
            sender.func_145747_a((ITextComponent)text);
        } else if (params.length == 0) {
            int dim = playerMP.field_71093_bK;
            int x = playerMP.func_180425_c().func_177958_n();
            int z = playerMP.func_180425_c().func_177952_p();
            String message = this.DataRead(this.convertPosToRegion(x, z), dim, x, z);
            TextComponentString text = new TextComponentString(message);
            text.func_150256_b().func_150238_a(TextFormatting.BLUE);
            sender.func_145747_a((ITextComponent)text);
        }
    }

    public String func_71517_b() {
        return "getStructureName";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.getStructureName.usage";
    }

    boolean isStringInt(String a) {
        try {
            Integer.parseInt(a);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String convertPosToRegion(int xPos, int zPos) {
        int regionX = Math.round(xPos / 512);
        int regionZ = Math.round(zPos / 512);
        String regionName = "r." + Integer.toString(regionX) + "." + Integer.toString(regionZ);
        return regionName;
    }

    public String DataRead(String regionName, int dim, int xPos, int zPos) {
        File fileName = new File(DimensionManager.getCurrentSaveRootDirectory() + File.separator + "data" + File.separator + "QuestStructure" + File.separator + dim + File.separator + regionName + ".txt");
        try {
            String line;
            FileReader fileReader = new FileReader(fileName);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] tokens = line.split(",");
                int minX = Integer.parseInt(tokens[1]);
                int maxX = Integer.parseInt(tokens[2]);
                int minZ = Integer.parseInt(tokens[3]);
                int maxZ = Integer.parseInt(tokens[4]);
                if (minX >= xPos || xPos >= maxX || minZ >= zPos || zPos >= maxZ) continue;
                bufferedReader.close();
                return "The Recurrent Complex structure at this position is " + tokens[0];
            }
            bufferedReader.close();
            return "There is no Recurrent Complex structure here.";
        }
        catch (IOException ex) {
            if (ex instanceof FileNotFoundException) {
                System.out.println("BQ_RLC tried to access non-existant file" + ex);
                return "This region has not been created yet.";
            }
            System.out.println(ex);
            return "Error while processing data file.";
        }
    }
}

